/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.AbstractFlags8;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.misc.LevelIOComponent;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.registries.RegistryObject;

public abstract class WireComponentBase<T extends WireComponentBase<T>>
extends CircuitComponentBase<T>
implements Wire {
    private final WireConnectionState[] connections = new WireConnectionState[VecDirection.VALUES.length];
    private final WireConnectionState[] connectionsInternal = new WireConnectionState[VecDirection.VALUES.length];

    protected WireComponentBase(RegistryObject<ComponentType> type, ComponentContext context, InterfaceLookup<T> interfaceLookup) {
        super(type, context, interfaceLookup);
        Arrays.fill(this.connections, WireConnectionState.DISCONNECTED);
        Arrays.fill(this.connectionsInternal, WireConnectionState.DISCONNECTED);
    }

    protected abstract VecDirectionFlags getConnectableSides();

    @Nullable
    protected abstract CircuitComponent findConnectionTarget(VecDirection var1);

    protected abstract WireConnectionState getNextState(VecDirection var1, WireConnectionState var2, CircuitComponent var3, boolean var4);

    protected abstract boolean isValidState(VecDirection var1, WireConnectionState var2, CircuitComponent var3);

    protected abstract void onStateTransition(VecDirection var1, WireConnectionState var2, WireConnectionState var3);

    protected abstract void updateSignals(VecDirectionFlags var1);

    protected final WireConnectionState getState(VecDirection side) {
        return this.connections[side.ordinal()];
    }

    protected final WireConnectionState getStateInternal(VecDirection side) {
        return this.connectionsInternal[side.ordinal()];
    }

    protected final void setStateInternal(VecDirection side, WireConnectionState newState) {
        WireConnectionState prevState = this.getStateInternal(side);
        this.setState(side, newState);
        this.onStateTransition(side, prevState, newState);
    }

    public void setState(VecDirection side, WireConnectionState state) {
        this.connectionsInternal[side.ordinal()] = state;
        this.updateExternalState(true, () -> {
            this.connections[side.ordinal()] = state;
        });
    }

    public void onAdded() {
        super.onAdded();
        VecDirectionFlags sides = this.getConnectableSides();
        this.computeConnections(sides, sides);
        this.scheduleSequential();
    }

    public void update(ComponentEventMap events, boolean tick) {
        VecDirectionFlags neighborUpdates = (VecDirectionFlags)events.findAny(new CircuitEvent[]{CircuitEvent.NEIGHBOR_CHANGED}).onlyIn((AbstractFlags8)this.getConnectableSides());
        VecDirectionFlags redstoneUpdates = (VecDirectionFlags)events.findAny(new CircuitEvent[]{CircuitEvent.REDSTONE}).onlyIn((AbstractFlags8)this.getConnectableSides());
        this.computeConnections(neighborUpdates, redstoneUpdates);
    }

    private void computeConnections(VecDirectionFlags neighborUpdates, VecDirectionFlags redstoneUpdates) {
        VecDirectionFlags changedSides = VecDirectionFlags.none();
        for (VecDirection side : neighborUpdates) {
            WireConnectionState newState = this.computeNewState(side, false);
            if (newState == this.getStateInternal(side)) continue;
            this.setStateInternal(side, newState);
            changedSides = (VecDirectionFlags)changedSides.and((Enum)side);
        }
        VecDirectionFlags signalUpdates = (VecDirectionFlags)changedSides.and((AbstractFlags8)redstoneUpdates);
        if (!signalUpdates.isEmpty()) {
            this.updateSignals(signalUpdates);
        }
    }

    protected final WireConnectionState computeNewState(VecDirection side, boolean forceTransition) {
        WireConnectionState currentState = this.getStateInternal(side);
        CircuitComponent neighbor = this.findConnectionTarget(side);
        if (!forceTransition && neighbor instanceof LevelIOComponent) {
            return WireConnectionState.DISCONNECTED;
        }
        if (currentState == WireConnectionState.FORCE_DISCONNECTED && !forceTransition) {
            return neighbor == null ? WireConnectionState.DISCONNECTED : currentState;
        }
        if (neighbor == null) {
            return WireConnectionState.DISCONNECTED;
        }
        if (forceTransition || currentState == WireConnectionState.DISCONNECTED || !this.isValidState(side, currentState, neighbor)) {
            WireConnectionState newState = this.getNextState(side, forceTransition ? currentState : WireConnectionState.DISCONNECTED, neighbor, forceTransition);
            if (forceTransition && newState == WireConnectionState.DISCONNECTED) {
                return WireConnectionState.FORCE_DISCONNECTED;
            }
            return newState;
        }
        return currentState;
    }

    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        int[] states = new int[VecDirection.VALUES.length];
        for (int i = 0; i < this.connections.length; ++i) {
            states[i] = this.connections[i].serialize();
        }
        tag.m_128385_("connection_states", states);
        return tag;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        int[] states = tag.m_128465_("connection_states");
        for (int i = 0; i < this.connections.length; ++i) {
            this.connectionsInternal[i] = this.connections[i] = WireConnectionState.deserialize((int)states[i]);
        }
    }
}

